/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.common.KanaConvertUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.CommonConst;

public class CommonUtility {
	
	/**
	 * StringNullA`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0̏ꍇtrueAłȂꍇfalse</p>
	 */
	public boolean isNull(String str) {
		try {
			if (str == null || str.length() == 0) {
				return true;
			}
		} catch (NullPointerException e) {
			return true;
		}
		return false;
	}

	/**
	 * z񁨃J}؂̕
	 * @param array		Ώۈꎟz
	 * @return
	 */
	public String convArrayToFormattedByComma(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i]);
			if (i != array.length -1) {
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
			}
		}			
		return sb.toString();
	}

	/**
	 * z񎟌ϊ
	 * @param ary1D		ϊꎟz
	 * @return	ϊ񎟌z
	 */
	public String[][] convArrayDimension(String[] ary1D) {
		String[][] array = new String[1][2];
		array[0][0] = "";
		array[0][1] = "";
		if (ary1D != null) {
			array[0][0] = ary1D[0];
			array[0][1] = ary1D[1];
		}
		return array;
	}

	/**
	 * z񎟌ϊ
	 * @param ary2D		ϊ񎟌z
	 * @return	ϊꎟz
	 */
	public String[] convArrayDimension(String[][] ary2D) {
		String[] array = new String[2];
		array[0] = "";
		array[1] = "";
		if (ary2D != null) {
			array[0] = ary2D[0][0];
			array[1] = ary2D[0][1];
		}
		return array;
	}

	/**
	 * ꎟz񐶐
	 * @param str1		ΏۗvfP
	 * @param str2		ΏۗvfQ
	 * @return@z
	 */
	public String[] createArray(String str1, String str2) {
		return new String[]{ str1, str2 };
	}
	
	/**
	 * 󔒃v_E擾
	 * @return  󔒃v_Epz
	 */
	public String[][] getBlankArray() {
		String[][] array = new String[1][2];
		array[0][0] = "";
		array[0][1] = "";
		return array;
	}

	/**
	 * ݐE/ސEXg擾
	 * @return ݐE/ސEXg
	 */
	public String[][] getRetirementFlagArrayAll() {
		// z̍쐬
		return addArrayFirstRowSpace(getRetirementFlagArray());
	}

	/**
	 * ݐE/ސEXg擾i󗓖j
	 * @return ݐE/ސEXg
	 */
	public String[][] getRetirementFlagArray() {
		// z̍쐬
		String[][] aryRetirementFlag = new String[3][2];
		aryRetirementFlag[0][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_OFF);
		aryRetirementFlag[0][1] = CommonConst.NAM_RETIREMENT_OFF;
		aryRetirementFlag[1][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE);
		aryRetirementFlag[1][1] = CommonConst.NAM_RETIREMENT_LEAVE;
		aryRetirementFlag[2][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_ON);
		aryRetirementFlag[2][1] = CommonConst.NAM_RETIREMENT_ON;
		return aryRetirementFlag;
	}

	/**
	 * ̎擾
	 * @param code  擾ΏۃR[h
	 * @return R[h
	 */
	public String getCodeName(String code, String[][] array) {
		String codeName = code;
		if (array == null) {
			return codeName;
		}
		for (int i = 0; i < array.length; i++) {
			if (code.equals(array[i][0])) {
				codeName = array[i][1];
				break;
			}
		}
		return codeName;
	}

	/**
	 * R[h擾
	 * @param name  擾ΏۃR[h
	 * @param array  擾Ώ۔z
	 * @return R[h
	 */
	public String getCodeValue(String name, String[][] array) {
		String codeValue = name;
		if (array == null) {
			return codeValue;
		}
		for (int i = 0; i < array.length; i++) {
			if (name.equals(array[i][1])) {
				codeValue = array[i][0];
				break;
			}
		}
		return codeValue;
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	public String[][] getYearArray(int year) {
		String[][] aryYear = new String[3][2];
		aryYear[0][0] = String.valueOf(year - 1);
		aryYear[0][1] = String.valueOf(year - 1);
		aryYear[1][0] = String.valueOf(year);
		aryYear[1][1] = String.valueOf(year);
		aryYear[2][0] = String.valueOf(year + 1);
		aryYear[2][1] = String.valueOf(year + 1);
		return aryYear;
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @param former ߋ
	 * @param further 
	 * @return Nv_Epz
	 */
	public String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i ++) { 
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}

	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public String[][] getMonthArray() {
		String[][] aryMonth = new String[12][2];
		for (int i = 0; i < 12; i++) {
			aryMonth[i][0] = String.valueOf(i + 1);
			aryMonth[i][1] = String.valueOf(i + 1);
		}
		return aryMonth;
	}

	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public String[][] getDayArray() {
		String[][] aryDay = new String[31][2];
		for (int i = 0; i < 31; i++) {
			aryDay[i][0] = String.valueOf(i + 1);
			aryDay[i][1] = String.valueOf(i + 1);
		}
		return aryDay;
	}

	/**
	 * ԃv_E擾
	 * @param hour          Jn
	 * @param minute        Jn
	 * @param count         f[^
	 * @param interval      f[^Ԋu()
	 * @param isValueMinute ݒtO(trueFvalue͕PʁAfalseFvalue͎ԕ)
	 * @return ԃv_Epz
	 */
	public String[][] getTimeArray(int hour, int minute, int count, int interval, boolean isValueMinute) {
		String[][] aryTime = new String[count][2];
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, hour);
		cal.set(Calendar.MINUTE, minute);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		for (int i = 0; i < count; i++) {
			if (isValueMinute) {
				aryTime[i][0] = String.valueOf(cal.get(Calendar.HOUR_OF_DAY) * 60 + cal.get(Calendar.MINUTE));
			} else {
				aryTime[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_TIME_SHORT);
			}
			aryTime[i][1] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_TIME_SHORT);
			cal.add(Calendar.MINUTE, interval);
		}
		return aryTime;
	}

	/**
	 * lv_E擾
	 * @param start		Jnl
	 * @param end		Il
	 * @param interval	Ԋu
	 * @return lv_Epz
	 */
	public String[][] getCountArray(int start, int end, int interval) {
		int count = (end - start) / interval + 1;
		int value = start;
		String[][] aryCount = new String[count][2];
		for (int i = 0; i < count; i++) {
			aryCount[i][0] = String.valueOf(value);
			aryCount[i][1] = String.valueOf(value);
			value += interval;
		}
		return aryCount;
	}

	/**
	 * v_Es
	 * @param target Ώۃv_Ez
	 * @param value Ώۍsl
	 * @return v_E
	 */
	public String[][] removeArrayRow(String[][] target, String value) {
		int count = target.length;
		for (int i = 0; i < target.length; i++) {
			if (target[i][0].equals(value)) {
				--count;
			}
		}
		String[][] aryNew = new String[count][2];
		count = 0;
		for (int i = 0; i < target.length; i++) {
			if (target[i][0].equals(value)) {
				continue;
			}
			aryNew[count][0] = target[i][0];
			aryNew[count][1] = target[i][1];
			++count;
		}
		return aryNew;
	}

	/**
	 * v_E̐擪sɋ󔒂ǉ
	 * @param target Ώۃv_Ez
	 * @return ǉv_E
	 */
	public String[][] addArrayFirstRowSpace(String[][] target) {
		return addArrayFirstRowValue(target, "", "");
	}

	/**
	 * v_E̐擪sɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public String[][] addArrayFirstRowValue(String[][] target, String code, String value) {
		String[][] aryNew = new String[target.length + 1][2];
		for (int i = 0; i < aryNew.length; i++) {
			if (i == 0) {
				aryNew[0][0] = code;
				aryNew[0][1] = value;
			} else {
				aryNew[i][0] = target[i - 1][0];
				aryNew[i][1] = target[i - 1][1];
			}
		}
		return aryNew;
	}

	/**
	 * v_E̍ŏIsɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public String[][] addArrayLastRowValue(String[][] target, String code, String value) {
		String[][] aryNew = new String[target.length + 1][2];
		for (int i = 0; i < aryNew.length; i++) {
			if (i == aryNew.length -1) {
				aryNew[i][0] = code;
				aryNew[i][1] = value;
			} else {
				aryNew[i][0] = target[i][0];
				aryNew[i][1] = target[i][1];
			}
		}
		return aryNew;
	}

	/**
	 * 񎟌zꎟz֕ϊ
	 * @param ary Ώۓ񎟌z
	 * @param d INo.
	 * @return Iꎟz
	 * @throws Exception
	 */	
	public String[] separateArrayList(String[][] ary, int d) {
		String[] aryName = new String[ary.length];
		for (int i = 0; i < ary.length; i++) {
			aryName[i] = ary[i][d];
		}
		return aryName;
	}

	/**
	 * 擾
	 * @param date1 I
	 * @param date2 Jn
	 * @return (date1 - date2)
	 * @throws Exception
	 */
	public int getMonthRemainder(Date date1, Date date2) {
		int year1  = MospUtility.getYear (date1);
		int month1 = MospUtility.getMonth(date1);
		int year2  = MospUtility.getYear (date2);
		int month2 = MospUtility.getMonth(date2);
		int remainder = year1 * 12 + month1 - year2 * 12 - month2;
		return remainder;
	}

	/**
	 * 擾
	 * @param date1 I
	 * @param date2 Jn
	 * @return (date1 - date2)
	 * @throws Exception
	 */
	public long getDateRemainder(Date date1, Date date2) {
		long remainder = date1.getTime() - date2.getTime();
		return (remainder / (1000 * 60 * 60 * 24)) + 1;
	}

	/**
	 * N
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addYear(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.YEAR, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addMonth(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.MONTH, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addDay(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, amount);
		return cal.getTime();
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	public Date addDay(Date date, String amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, Integer.parseInt(amount));
		return cal.getTime();
	}

	/**
	 * t擾iStringj
	 * @return tl
	 */
	public Date getInitialDate() { 
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date(0));
		return cal.getTime();
	}

	/**
	 * VXet擾
	 * @return VXet
	 */
	public Date getSystemDate() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * VXet擾
	 * @return VXet
	 */
	public Date getNowDate() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * 擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return 
	 */
	public Date getFirstDateOfMonth(String year, String month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(year));
		cal.set(Calendar.MONTH, Integer.parseInt(month) - 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * 擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return 
	 */
	public Date getFirstDateOfMonth(int year, int month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month - 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * ŏI擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return ŏI
	 */
	public Date getLastDateOfMonth(String year, String month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(year));
		cal.set(Calendar.MONTH, Integer.parseInt(month));
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * ŏI擾
	 * @param year  擾Ώ۔N
	 * @param month 擾Ώی
	 * @return ŏI
	 */
	public Date getLastDateOfMonth(int year, int month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * N擾
	 * @param year  N
	 * @param month 
	 * @return N
	 */
	public Date getYearMonth(String year, String month) {
		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(year), Integer.parseInt(month) -1, 1, 0, 0, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * Ԏ擾
	 * @param time 
	 * @return t
	 * @throws ParseException 
	 */
	public Date getTimeAsDate(String time) throws ParseException {
		Date date = DateFormat.getTimeInstance(DateFormat.SHORT).parse(time);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.YEAR, CommonConst.TIME_DEFAULT_YEAR);
		cal.set(Calendar.MONTH, CommonConst.TIME_DEFAULT_MONTH);
		cal.set(Calendar.DAY_OF_MONTH, CommonConst.TIME_DEFAULT_DAY);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}

	/**
	 * I܂ވTԂ̊Jn擾
	 * @param date			I
	 * @param dayofweek		Jnj
	 * @return I܂ވTԂ̊Jn
	 */
	public Date getFirstDateOfTargetWeek(Date date, int dayofweek) {
		Calendar cal = Calendar.getInstance();
		cal.setFirstDayOfWeek(dayofweek);
		cal.setTime(date);
		cal.set(Calendar.DAY_OF_WEEK, cal.getFirstDayOfWeek());
		return cal.getTime();
	}

	/**
	 * I܂ވTԂ̏I擾
	 * @param date			I
	 * @param dayofweek		Jnj
	 * @return I܂ވTԂ̏I
	 */
	public Date getLastDateOfTargetWeek(Date date, int dayofweek) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(getFirstDateOfTargetWeek(date, dayofweek));
		cal.add(Calendar.DATE, 6);
		return cal.getTime();
	}

	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public String getCsvData(String data) {
		if (data == null) {
			return "";
		}
		String newData = data.replaceAll("\"", "\"\"");
		return "\"" + newData + "\"";
	}

	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public String getCsvData(int data) {
		return "\"" + String.valueOf(data) + "\"";
	}

	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public String getCsvData(float data) {
		return "\"" + String.valueOf(data) + "\"";
	}

	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public String getCsvData(Date data) {
		if (data == null) {
			return "";
		}
		String newData = MospUtility.getDateString(data, CommonConst.FORMAT_DATE);
		return "\"" + newData + "\"";
	}

	/**
	 * X֔ԍ\bh
	 * @param	code X֔ԍ
	 * @return O3
	 */
	public String divideYubinCodeForward(String code) {
		String[] ar = code.split(CommonConst.STR_SEPARATOR);
		if (ar.length > 0) {
			return ar[0];
		} else {
			return "";
		}	
	}

	/**
	 * X֔ԍ\bh
	 * @param	code X֔ԍ
	 * @return 4
	 */
	public String divideYubinCodeBackward(String code) {
		String[] ar = code.split(CommonConst.STR_SEPARATOR);
		if (ar.length > 1) {
			return ar[1];
		} else {
			return "";
		}
	}

	/**
	 * nCt\bh
	 * @param code Ώۃf[^
	 * @param hyphen nCt
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public String[] divideByHyphen(String code, int hyphen) {
		String[] base = code.split(CommonConst.FILE_NAME_SEPARATOR);
		String[] ar = new String[hyphen + 1];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * nCt\bh
	 * @param code Ώۃf[^
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB<br>
	 * nCtŕ񂪏IꍇAnCt̑O̕܂łA
	 * zɂB
	 */
	public String[] divideByHyphen(String code) {
		String[] base = code.split(CommonConst.FILE_NAME_SEPARATOR);
		String[] ar = new String[base.length];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * J}\bh
	 * @param code Ώۃf[^
	 * @param comma J}
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public String[] divideByComma(String code, int comma) {
		String[] base = code.split(CommonConst.KEY_SEPARATOR);
		String[] ar = new String[comma + 1];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * J}\bh
	 * @param code Ώۃf[^
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 */
	public String[] divideByComma(String code) {
		String[] base = code.split(CommonConst.KEY_SEPARATOR);
		String[] ar = new String[base.length];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * J}\bh
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	public String combineByComma(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i]);
			if (i < array.length - 1) {
				sb.append(CommonConst.KEY_SEPARATOR);
			}			
		}
		return sb.toString();
	}

	/**
	 * XbV\bh
	 * @param code		ΏۃR[h
	 * @return@z
	 */
	public String[] divideBySlash(String code) {
		String[] base = code.split(CommonConst.SEPARATOR_DATE);
		String[] ar = new String[base.length];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * XbV\bh
	 * @param code		ΏۃR[h
	 * @param slash		XbV
	 * @return@z
	 */
	public String[] divideBySlash(String code, int slash) {
		String[] base = code.split(CommonConst.SEPARATOR_DATE);
		String[] ar = new String[slash + 1];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * nullɏlZbg
	 * @param obj
	 * @param init
	 * @return	string ϊ
	 */
	public String convNullToInitialValue(Object obj, String init) {
		String value = init;
		if (obj == null) {
			return value;
		} else {
			return (String)obj;
		}
	}

	/**
	 * Ζ`Ԏϊ\bh
	 * @param start
	 * @param quit
	 * @return	string	
	 */
	public String convWorkTypeTimes(int start, int quit) {
		StringBuffer sb = new StringBuffer();
		// oΎ
		if ((start / 60) < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(start / 60));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if ((start % 60) < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(start % 60));
		sb.append(CommonConst.STR_SLASH_SEPARATOR);
		// ގЎ
		int quith = (quit / 60);
		if (quith > 24) {
			sb.append(CommonConst.NAM_NEXT);
			quith = quith - 24;
		}
		if (quith < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(quith));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if ((quit % 60) < 10) {
			sb.append("0");
		}
		sb.append(String.valueOf(quit % 60));
		return sb.toString();
	}

	/**
	 * int̎ԂStringɕϊ
	 * @param time
	 * @return	string	ԁij
	 */
	public String convIntegerTimeToStringHour(int time) {
		return String.valueOf(time / 60);
	}

	/**
	 * int̕Stringɕϊ
	 * @param time
	 * @return	string	ԁij
	 */
	public String convIntegerTimeToStringMinutes(int time) {
		return String.valueOf(time % 60);
	}

	/**
	 * String̎ԂStringɕϊ
	 * @param time HH:MM
	 * @return HH
	 */
	public String convStringTimeToStringHour(String time) {
		if (time.equals("")) {
			return "0";
		} else {
			return convIntegerTimeToStringHour(convStringTimeToIntegerTime(time));
		}
	}

	/**
	 * String̕Stringɕϊ
	 * @param time HH:MM
	 * @return MM
	 */
	public String convStringTimeToStringMinutes(String time) {
		if (time.equals("")) {
			return "0";
		} else {
			return convIntegerTimeToStringMinutes(convStringTimeToIntegerTime(time));
		}
	}

	/**
	 * ϊiintStringj
	 * @param time int
	 * @return HH:MM
	 */
	public String convIntegerTimeToStringTime(int time) {
		StringBuffer sb = new StringBuffer();
		if (convIntegerTimeToStringHour(time).length() < 2) {
			sb.append("0");
		}
		sb.append(convIntegerTimeToStringHour(time));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if (convIntegerTimeToStringMinutes(time).length() < 2) {
			sb.append("0");			
		}
		sb.append(convIntegerTimeToStringMinutes(time));
		return sb.toString();
	}

	/**
	 * ϊiintStringj
	 * @param time int
	 * @return HHMM
	 */
	public String convIntegerTimeToJPTime(int time) {
		StringBuffer sb = new StringBuffer();
		if (convIntegerTimeToStringHour(time).length() < 2) {
			sb.append("0");
		}
		sb.append(convIntegerTimeToStringHour(time));
		sb.append(CommonConst.NAM_HOUR);
		if (convIntegerTimeToStringMinutes(time).length() < 2) {
			sb.append("0");			
		}
		sb.append(convIntegerTimeToStringMinutes(time));
		sb.append(CommonConst.NAM_MINUTES);
		return sb.toString();
	}

	/**
	 * ϊiStringintj
	 * @param time iHH:MMj
	 * @return int	i0̌oߕj
	 */
	public int convStringTimeToIntegerTime(String time) {
		int inttime = 0;
		if (time.length() == 0) {
			time = "0:0";
		}
		String[] ar = time.split(CommonConst.STR_TIME_SEPARATOR);
		inttime = Integer.parseInt(ar[0]) * 60 + Integer.parseInt(ar[1]);
		return inttime;
	}

	/**
	 * ϊiStringintj
	 * @param hour 
	 * @param min 
	 * @return int	i0̌oߕj
	 */
	public int convStringTimeToIntegerTime(String hour, String min) {
		if (hour.equals("")) {
			hour = "0";
		}
		if (min.equals("")) {
			min = "0";
		}		
		int times = (Integer.parseInt(hour) * 60) + Integer.parseInt(min);
		return times;
	}

	/**
	 * ϊiStringStringj
	 * @param hour 
	 * @param min 
	 * @return	HH:mm
	 */
	public String convStringTimeFormatted(String hour, String min) {
		StringBuffer sb = new StringBuffer();
		if (hour.equals("")) {
			hour = "0";
		}
		if (hour.length() < 2) {
			hour = "0" + hour;
		}
		sb.append(hour);
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if (min.equals("")) {
			min = "0";
		}		
		if (min.length() < 2) {
			min = "0" + min;
		}
		sb.append(min);
		return sb.toString();
	}

	/**
	 * ԕϊiintdoublej
	 * @param time int
	 * @return hh.mm <br>͂̂܂
	 * 				[] 651.05
	 */
	public double convIntegerTimeToDoubleTime(int time) {
		double dblhour = Math.floor((double)time / 60);
		double dblmin =(double)time % 60 / 100;
		double dtime = dblhour + dblmin;
		return dtime;
	}

	/**
	 * ԕϊiintStringj
	 * <p>[] 901.5</p>
	 * <p>15Pʂ̏ꍇ̂ݗpĂB</p>
	 * @param time int
	 * @return hh.mm 
	 */
	public String convIntegerMinToStringHour(int time) {
		double dblhour = Math.floor((double)time / 60);
		double dblmin = (double)time % 60 / 60;
		double dtime = dblhour + dblmin;
		return String.valueOf(dtime);
	}

	/**
	 * ԕϊiintStringj
	 * @param time int
	 * @return HHMM
	 */
	public String convIntegerTimeToJPHours(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(convIntegerTimeToStringHour(time));
		sb.append(CommonConst.NAM_COMMON_TIME);
		if (convIntegerTimeToStringMinutes(time).length() < 2) {
			sb.append("0");			
		}
		sb.append(convIntegerTimeToStringMinutes(time));
		sb.append(CommonConst.NAM_MINUTES);
		return sb.toString();
	}

	/**
	 * m_codepR[h\bh
	 * @param h1
	 * @param m1
	 * @param h2
	 * @param m2
	 * @return	string	
	 */
	public String convStringToTimeCode(String h1, String m1, String h2, String m2) {
		StringBuffer sb = new StringBuffer();
		if (h1.length() < 2) {
			sb.append("0");
		}
		sb.append(h1);
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if (m1.length() < 2) {
			sb.append("0");
		}
		sb.append(m1);
		sb.append(CommonConst.SEPARATOR_DATE);
		if (h2.length() < 2) {
			sb.append("0");
		}
		sb.append(h2);
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		if (m2.length() < 2) {
			sb.append("0");
		}
		sb.append(m2);
		sb.append(CommonConst.SEPARATOR_DATE);
		return sb.toString();
	}

	/**
	 * tϊ(intString[])
	 * @param date Ώۓt
	 * @return tz
	 */
	public String[] convIntegerDateToArray(int date) {
		String[] arDate = new String[3];
		if (date > 19000101) {
			String strDate = String.valueOf(date);
			arDate[0] = strDate.substring(0, 4);
			arDate[1] = String.valueOf(Integer.parseInt(strDate.substring(4, 6)));
			arDate[2] = String.valueOf(Integer.parseInt(strDate.substring(6, 8)));
		} else {
			arDate[0] = "1900";
			arDate[1] = "01";
			arDate[2] = "01";
		}
		return arDate;
	}

	/**
	 * tϊ(intString)
	 * @param date Ώۓt
	 * @return yyyyNmmdd
	 */
	public String convIntegerDateToString(int date) {
		StringBuffer sb = new StringBuffer();
		String[] ar = convIntegerDateToArray(date);
		sb.append(ar[0]);
		sb.append(CommonConst.NAM_YEAR);
		sb.append(ar[1]);
		sb.append(CommonConst.NAM_MONTH);
		sb.append(ar[2]);
		sb.append(CommonConst.NAM_DAY);
		return sb.toString();
	}

	/**
	 * tϊ(intString)
	 * @param date Ώۓt
	 * @return yyyy/mm/dd
	 */
	public String convIntegerDateToStringFormatted(int date) {
		StringBuffer sb = new StringBuffer();
		String[] ar = convIntegerDateToArray(date);
		sb.append(ar[0]);
		sb.append(CommonConst.SEPARATOR_DATE);
		sb.append(ar[1]);
		sb.append(CommonConst.SEPARATOR_DATE);
		sb.append(ar[2]);
		return sb.toString();
	}

	/**
	 * tϊ(Stringint)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyymmdd
	 */
	public int convStringDateToInteger(String yyyy, String mm, String dd) {
		return Integer.parseInt(yyyy) * 10000 + Integer.parseInt(mm) * 100 	+ Integer.parseInt(dd);
	}

	/**
	 * tϊ(Stringint)
	 * @param yyyy-mm-dd
	 * @return yyyymmdd
	 */
	public int convStringDateToInteger(String yyyymmdd) {
		int date = 0;
		String day[] = divideByHyphen(yyyymmdd);		
		date = convStringDateToInteger(day[0], day[1], day[2]);
		return date;		
	}

	/**
	 * tϊ(intString)
	 * @param yyyy
	 * @param mm
	 * @param dd
	 * @return	string	tiyyyymmddj
	 */
	public String convIntegerToStringDate(int yyyy, int mm, int dd) {
		return String.valueOf((yyyy * 10000) + (mm * 100) + dd);
	}

	/**
	 * tϊ(Dateint)
	 * @param date
	 * @return yyyymmdd
	 */
	public int convDateToInteger(Date date) {
		return MospUtility.getYear(date) * 10000 + MospUtility.getMonth(date) * 100 + MospUtility.getDay(date);
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyymmdd
	 */
	public String convDateToString(Date date) {
		return String.valueOf(convDateToInteger(date));
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-mm
	 */
	public String convDateToStringYearMonth(Date date) {
		StringBuffer sb = new StringBuffer();
		sb.append(MospUtility.getYear(date));
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		if (MospUtility.getMonth(date) < 10) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(MospUtility.getMonth(date));
		return sb.toString();
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-m
	 */
	public String convDateToStringYearMonthShort(Date date) {
		StringBuffer sb = new StringBuffer();
		sb.append(MospUtility.getYear(date));
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		sb.append(MospUtility.getMonth(date));
		return sb.toString();
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy-mm-dd
	 */
	public String convDateFormattedByHyphen(Date date) {
		StringBuffer sb = new StringBuffer();
		sb.append(MospUtility.getYear(date));
		String mm = String.valueOf(MospUtility.getMonth(date));
		if (mm.length() < 2) {
			mm = "0" + mm;
		}
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		sb.append(mm);
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		String dd = String.valueOf(MospUtility.getDay(date));
		if (dd.length() < 2) {
			dd = "0" + dd;
		}
		sb.append(dd);
		return sb.toString();
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy/mm/dd
	 */
	public String convDateFormatted(Date date) {
		StringBuffer sb = new StringBuffer();
		sb.append(MospUtility.getYear(date));
		String mm = String.valueOf(MospUtility.getMonth(date));
		if (mm.length() < 2) {
			mm = "0" + mm;
		}
		sb.append(CommonConst.SEPARATOR_DATE);
		sb.append(mm);
		sb.append(CommonConst.SEPARATOR_DATE);
		String dd = String.valueOf(MospUtility.getDay(date));
		if (dd.length() < 2) {
			dd = "0" + dd;
		}
		sb.append(dd);
		return sb.toString();
	}

	/**
	 * tϊ(DateString)
	 * @param date
	 * @return yyyy,mm,dd
	 */
	public String convDateFormattedByComma(Date date) {
		StringBuffer sb = new StringBuffer();
		sb.append(MospUtility.getYear(date));
		String mm = String.valueOf(MospUtility.getMonth(date));
		if (mm.length() < 2) {
			mm = "0" + mm;
		}
		sb.append(MospConst.DATA_SEPARATOR);
		sb.append(mm);
		sb.append(MospConst.DATA_SEPARATOR);
		String dd = String.valueOf(MospUtility.getDay(date));
		if (dd.length() < 2) {
			dd = "0" + dd;
		}
		sb.append(dd);
		return sb.toString();
	}

	/**
	 * tϊ(DateString)
	 * @param date	date
	 * @return yyyyNMMdd
	 */
	public String convDateToFormatDateJP(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_JP);
	}

	/**
	 * tϊ(DateString)
	 * @param date	date
	 * @return yyyyNMd
	 */
	public String convDateToFormatDateJPShort(Date date) {
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_JP_SHORT);
	}

	/**
	 * tϊ(StringString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy/mm/dd
	 */
	public String convStringDateFormatted(String yyyy, String mm, String dd) {
		StringBuffer sb = new StringBuffer();
		sb.append(yyyy);
		if (mm.length() < 2) {
			mm = "0" + mm;
		}
		sb.append(CommonConst.SEPARATOR_DATE);
		sb.append(mm);
		sb.append(CommonConst.SEPARATOR_DATE);
		if (dd.length() < 2) {
			dd = "0" + dd;
		}
		sb.append(dd);
		return sb.toString();
	}

	/**
	 * tϊ(StringString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy,mm,dd
	 */
	public String convStringDateFormattedByComma(String yyyy, String mm, String dd) {
		StringBuffer sb = new StringBuffer();
		sb.append(yyyy);
		if (mm.length() < 2) {
			mm = "0" + mm;
		}
		sb.append(MospConst.DATA_SEPARATOR);
		sb.append(mm);
		sb.append(MospConst.DATA_SEPARATOR);
		if (dd.length() < 2) {
			dd = "0" + dd;
		}
		sb.append(dd);
		return sb.toString();
	}

	/**
	 * tϊ(StringString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy-mm-dd
	 */
	public String convStringDateFormattedByHyphen(String yyyy, String mm, String dd) {
		StringBuffer sb = new StringBuffer();
		sb.append(yyyy);
		if (mm.length() < 2) {
			mm = "0" + mm;
		}
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		sb.append(mm);
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		if (dd.length() < 2) {
			dd = "0" + dd;
		}
		sb.append(dd);
		return sb.toString();
	}

	/**
	 * tϊ(intString)
	 * @param yyyy N
	 * @param mm 
	 * @param dd 
	 * @return yyyy-mm-dd
	 */
	public String convDateFormattedByHyphen(int yyyy, int mm, int dd) {
		StringBuffer sb = new StringBuffer();
		sb.append(yyyy);
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		sb.append(addZero(mm));
		sb.append(CommonConst.FILE_NAME_SEPARATOR);
		sb.append(addZero(dd));
		return sb.toString();
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd	yyyy/mm/dd
	 * @return date
	 */
	public Date convStringDateToDate(String yyyymmdd) {
		Date date;
		try {
			date = new SimpleDateFormat(CommonConst.FORMAT_DATE).parse(yyyymmdd);
		} catch (ParseException e) {
			return null;
		}
		return date;
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd yyyyMMdd
	 * @return date
	 */
	public Date convStringBaseDateToDate(String yyyymmdd) {
		Date date;
		try {
			date = new SimpleDateFormat(CommonConst.FORMAT_DATE_BASE).parse(yyyymmdd);
		} catch (ParseException e) {
			return null;
		}
		return date;
	}

	/**
	 * tϊ(StringString[])
	 * @param yyyymmdd Ώۓt(yyyy/mm/dd)
	 * @return tz
	 */
	public String[] convStringDateToArray(String yyyymmdd) {
		String[] arDate = new String[3];
		if (yyyymmdd.equals("")) {
			for (int i = 0; i < 3; i++) {
				arDate[i] = "";
			}
		} else {
			arDate[0] = removeZero(yyyymmdd.split(CommonConst.SEPARATOR_DATE)[0]);
			arDate[1] = removeZero(yyyymmdd.split(CommonConst.SEPARATOR_DATE)[1]);
			arDate[2] = removeZero(yyyymmdd.split(CommonConst.SEPARATOR_DATE)[2]);
		}
		return arDate;
	}

	/**
	 * tϊiintDatej
	 * @param yyyymmdd
	 * @return date
	 */
	public Date convIntegerDateToDate(int yyyymmdd) {
		Date date;
		try {
			date = new SimpleDateFormat(CommonConst.FORMAT_DATE)
			.parse(convIntegerDateToStringFormatted(yyyymmdd));
		} catch (ParseException e) {
			return null;
		}
		return date;
	}

	/**
	 * tϊ(intDate)
	 * @param year
	 * @param month
	 * @param day
	 * @return	Date	Ώ۔N
	 */
	public Date getDate(int year, int month, int day) {
		Calendar cal = Calendar.getInstance();
		cal.set(year, month - 1, day);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime(); 
	}

	/**
	 * tϊ(StringDate)
	 * @param year
	 * @param month
	 * @param day
	 * @return	Date	Ώ۔N
	 */
	public Date getDate(String year, String month, String day) {
		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime(); 
	}

	/**
	 * tϊiStringDatej
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return date
	 */
	public Date convHyphenDateToDate(String yyyymmdd) {
		Date date;
		try {
			date = new SimpleDateFormat(CommonConst.FORMAT_FOR_ATTENDANCELIST).parse(yyyymmdd);
		} catch (ParseException e) {
			return null;
		}
		return date;
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return yyyyNMd
	 */
	public String convHyphenDateToJPShortDate(String yyyymmdd) {
		Date date = convHyphenDateToDate(yyyymmdd);
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_JP_SHORT);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return yyyyNMMdd
	 */
	public String convHyphenDateToJPDate(String yyyymmdd) {
		Date date = convHyphenDateToDate(yyyymmdd);
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE_JP);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy-mm-dd
	 * @return yyyy/MM/dd
	 */
	public String convHyphenDateToFormatted(String yyyymmdd) {
		Date date = convHyphenDateToDate(yyyymmdd);
		return MospUtility.getDateString(date, CommonConst.FORMAT_DATE);
	}

	/**
	 * tϊiStringStringj
	 * @param yyyymmdd	yyyy/mm/dd
	 * @return yyyy-MM-dd
	 */
	public String convFormattedToHyphen(String yyyymmdd) {
		Date date = convStringDateToDate(yyyymmdd);
		return convDateFormattedByHyphen(date);
	}

	/**
	 * 𕪊
	 * @param Sspl1
	 * @param Sspl2
	 * @param Sspl3
	 * @return	
	 */
	public static String splitStrings(String Sspl1, String Sspl2, int Sspl3) {
		if (Sspl1.length() > 0){
			if (Sspl1.indexOf(Sspl2) != -1)  {
				int i = Sspl1.indexOf(Sspl2);
				if (Sspl3 == 0) {
					return Sspl1.substring(0,i);
				} else {
					return Sspl1.substring(i+1,Sspl1.length());
				}
			} else {
				return Sspl1;
			}
		} else {
			return "";
		}
	}

	/**
	 * t擾iStringj
	 * @return	9999-99-99 00:00:00
	 */
	public String getDateTime() { 
		StringBuffer datetime = new StringBuffer();
		SimpleDateFormat sdfymd = new SimpleDateFormat(CommonConst.FORMAT_DATE);
		SimpleDateFormat sdfhms = new SimpleDateFormat(CommonConst.FORMAT_TIME);
		datetime.append(sdfymd.format(getSystemDate()));
		datetime.append(" ");
		datetime.append(sdfhms.format(getSystemDate()));
		return datetime.toString();
	}

	/**
	 * t擾iStringj
	 * @param date
	 * @return 9999-99-99 99:99:99
	 */
	public String getDateTime(Date date) { 
		StringBuffer datetime = new StringBuffer();
		SimpleDateFormat sdfymd = new SimpleDateFormat(CommonConst.FORMAT_DATE);
		SimpleDateFormat sdfhms = new SimpleDateFormat(CommonConst.FORMAT_TIME);
		datetime.append(sdfymd.format(date));
		datetime.append(" ");
		datetime.append(sdfhms.format(date));
		return datetime.toString();
	}

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @param falseflag falseԂ
	 * @return  ǂłȂꍇfalse
	 */
	public boolean convFlagToBoolean(String target, String trueflag, String falseflag) {
		if (target.equals(trueflag)) {
			return true;
		} else if (target.equals(falseflag)) {
			return false;
		} else {
			return false;
		}
	}

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @return 
	 */
	public boolean convFlagToBoolean(String target, String trueflag) {
		if (target.equals(trueflag)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * tOϊiintbooleanj
	 * @param target Ώint
	 * @param trueflag trueԂ
	 * @return 
	 */
	public boolean convFlagToBoolean(int target, int trueflag) {
		if (target == trueflag) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * tOϊibooleanStringj
	 * @param isTrue 	truȅꍇString
	 * @param isFalse	falsȅꍇString
	 * @param flag 		true or false
	 * @return	String 	ʖ
	 */
	public String returnStringFlag(String isTrue, String isFalse, boolean flag) {
		if (flag) {
			return isTrue;
		} else {
			return isFalse;
		}
	}

	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truecOFFAfalsecON
	 */
	public String returnTrueIsOff(boolean flag) {
		if (flag) {
			return CommonConst.NAM_COMMON_FLAG_OFF;
		} else {
			return CommonConst.NAM_COMMON_FLAG_ON;
		}
	}

	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truecONAfalsecOFF
	 */
	public String returnTrueIsOn(boolean flag) {
		if (flag) {
			return CommonConst.NAM_COMMON_FLAG_ON;
		} else {
			return CommonConst.NAM_COMMON_FLAG_OFF;
		}
	}

	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public String[][] combineArray(String[][] frontarray, String[][] behindarray) {
		String[][] result = new String[frontarray.length + behindarray.length][2];
		System.arraycopy(frontarray, 0, result, 0, frontarray.length);
		System.arraycopy(behindarray, 0, result, frontarray.length, behindarray.length);			
		return result;
	}

	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param centerarray ns2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public String[][] combineArray(String[][] frontarray, String[][] centerarray, String[][] behindarray) {
		String[][] result = combineArray(combineArray(frontarray, centerarray), behindarray);
		return result;
	}

	/**
	 * z񓯎m̌
	 * @param list
	 * @return
	 */
	public String[][] combineArray(List<String[][]> list) {
		String[][] result = new String[0][2];
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String[][] array = (String[][]) iter.next();
			result = combineArray(result, array);
		}
		return result.clone();
	}
	
	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public String[][] getExistenceArray() {
		String[][] result = new String[2][2];
		result[0][0] = CommonConst.NAM_COMMON_FLAG_OFF;
		result[0][1] = CommonConst.NAM_COMMON_NASI;
		result[1][0] = CommonConst.NAM_COMMON_FLAG_ON;
		result[1][1] = CommonConst.NAM_COMMON_ARI;
		return result;
	}

	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public String[][] getExistenceShortArray() {
		String[][] result = new String[2][2];
		result[0][0] = CommonConst.NAM_COMMON_FLAG_OFF;
		result[0][1] = CommonConst.NAM_MISSING_INPUT_OFF_OPT;
		result[1][0] = CommonConst.NAM_COMMON_FLAG_ON;
		result[1][1] = CommonConst.NAM_MISSING_INPUT_ON;
		return result;
	}

	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	public String getHourString(double hour) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(2);
		nf.setMinimumFractionDigits(2);
		return nf.format(hour);
	}

	/**
	 * tH[}bg
	 * @param number 
	 * @param max 
	 * @param min _ȉ
	 * @return ()
	 */
	public String getNumberString(double number, int max, int min) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(max);
		nf.setMinimumFractionDigits(min);
		return nf.format(number);
	}


	/**
	 * s\
	 * @param aStr sΏە
	 * @return s㕶
	 */
	public static String brHTML(String aStr) {
		char c;
		String strTarget = aStr != null ? aStr : "";
		StringBuffer returnStr = new StringBuffer();
		int length = strTarget.length();
		for (int i = 0; i < length; i++) {
			c = strTarget.charAt(i); 
			if (c == '\n') {
				returnStr = returnStr.append("<br>");
			} else if (c == '<') {
				returnStr = returnStr.append("&lt;");
			} else if(c == '>') {
				returnStr = returnStr.append("&gt;");
			} else if(c == '&') {
				returnStr = returnStr.append("&amp;");
			} else if(c == '"') {
				returnStr = returnStr.append("&quot;");
			} else if(c == '\'') {
				returnStr = returnStr.append("&#39;");
			} else {
				returnStr = returnStr.append(c);
			}
		}
		return new String(returnStr);
	}

	/**
	 * [t̐琮֕ϊ
	 * @param number [t
	 * @return 
	 */
	public String removeZero(String number) {
		return String.valueOf(Integer.parseInt(number));
	}

	/**
	 * [t̐֕ϊ
	 * @param number
	 * @return String	i0~9ji00~09j
	 */
	public String addZero(int number) {
		StringBuffer sb = new StringBuffer();
		if (number < 10) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(number);
		return sb.toString();
	}

	/**
	 * [t̐֕ϊ
	 * @param number
	 * @return String	i0~9ji00~09j
	 */
	public String addZero(String number) {
		StringBuffer sb = new StringBuffer();
		if (number.length() < 2) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(number);
		return sb.toString();
	}

	/**
	 * ̑݃`FbN
	 * @param value			ΏۃR[h
	 * @param aryTarget		Ώۖ̂܂ޔz
	 * @return
	 * <p>
	 * ݂̂ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public boolean checkNameExist(String value, String[][] aryTarget) {
		String target = getCodeName(value, aryTarget);
		if (target.equals(value)) {
			return false;
		}
		return true;
	}

	/**
	 * z`FbN
	 * @param ary1		Ώ۔zP
	 * @param ary2		Ώ۔zQ
	 * @return
	 * <p>
	 * z񂪈ꏏłtrueAłȂꍇfalse
	 * </p>
	 */
	public boolean checkArraysEquals(String[] ary1, String[] ary2) {
		if (Arrays.equals(ary1, ary2)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 𔼊pJi֓
	 * @param input		Ώۉ
	 * @return	pJiϊ㕶
	 */
	public String toHankakuKana(String input) {
		return KanaConvertUtility.convZenkakuToHankaku(KanaConvertUtility.convHiraGanaToHankaku(input));
	}

	/**
	 * SpXy[X𔼊pXy[X֕ϊ
	 * @param input		SpXy[X܂܂镶
	 * @return	SpXy[X𔼊pXy[X֕ϊ̕
	 */
	public String to1byteSpace(String input) {
		StringBuffer sb = new StringBuffer();
		String[] aryInput = input.split("@");
		for (int i = 0; i < aryInput.length; i++) {
			sb.append(aryInput[i]);
			if (i != aryInput.length -1) {
				sb.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
		}
		return sb.toString();
	}

	/**
	 * ꎟzList
	 * @param array
	 * @return
	 */
	public List<String> arrayToList(String[] array) {
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < array.length; i++) {
			list.add(array[i]);
		}
		return list;
	}
	
}
